# HEGS data release

The data in this archive are released along with the publication "The H.E.S.S. extragalactic sky survey with the first
decade of observations", by the H.E.S.S. collaboration (Astronomy & Astrophysics, 2025).

DOI : 10.1051/0004-6361/202452723

## Data analysis details

As described in the paper, the data (DST version : Prod26_NewPointing) were analyzed using the ParisAnalysis software (version HESS_Soft_0-8-24) with the Model++ analysis using the "Loose" cuts (de Naurois, M. & Rolland, L. 2009, Astroparticle Physics, 32, 231).

## Archive content

The data that are released together with the present paper consist of a set of FITS files containing the description of the observations, the catalogue and the maps. 

All the observations in this dataset have been grouped by clusters of observation as described in the publication. Each cluster is an independent sky region. The released sky maps were produced independently for each cluster, and each cluster is named according to the sky coordinates of its center.

The following files are released. The definitions of the tables are described in the "Tables details" section below.

### File structure

- HEGS_Archive/
    - README.md
    - HEGS_Data/
        - HEGS_JHHmm±DDd_Maps_Loose_Index3.fits.gz files
        - HEGS_FOVs_v1.fits
        - HEGS_catalogue_v1.fits
        - HEGS_NotConstrainedSources_v1.fits
    - Scripts/
        - CheckPositionHEGS.ipynb
        - CheckPositionHEGS.py
        - PlotCatalogSpectrum.ipynb
        - PlotHEGSFermi.ipynb
        - PlotLibrary.py
        - ReadFermiCatalogs.py

### HEGS_Data folder

#### HEGS_FOVs_v1.fits 

This file lists the HEGS clusters and contains two entries : 

- HEGS_FOVS : lists the names, positions and extension of each observed field-of-view. 
- HEGS_FOVS_NIGHTLY_LIVETIMES : lists the observed live time per night for each cluster. Note that this is only indicative. Since a field-of-view can be extended on the sky, some observation time in a night for a given field-of-view doesn't necessarily mean that the whole area of the cluster has been observed on that particular night.

#### HEGS_catalogue_v1.fits 

The HEGS catalogue, which contains several entries:

- HEGS_sources : lists the main catalogue results with one source per row.
- Association : Association of HEGS source with one source per row.
- Constrained sources : Fermi-LAT sources within the HEGS FoV that are constrained by the H.E.S.S. observations.

#### Maps files 

For each cluster, a set of maps is released in one FITS file, named `HEGS_JHHmm±DDd_Maps_Loose_Index3.fits.gz` from the cluster name as listed in the HEGS_FOVs.fits file. See below for the content of the files.  

#### HEGS_NotConstrainedSources_v1.fits 

Fermi-LAT sources in the FoV of HEGS that are not constrained by the H.E.S.S. observations. The definition is the same as the "Constrained sources" one.

### Scripts folder

The following scripts are provided to help explore the files. They have been tested using gammapy v1.3 (https://docs.gammapy.org/1.3/index.html).

- `CheckPositionHEGS.py` : script to search for a position in the whole archive. If the searched position has been observed, some stats will be printed and a map will be displayed. 
- `CheckPositionHEGS.ipynb` is a jupyter notebook version of the `CheckPositionHEGS.py` script.
-  `PlotCatalogSpectrum.ipynb` : script to plot a spectrum from the catalog. In order to use this script, the `PlotLibrary.py` class is needed.
- `PlotHEGSFermi.ipynb` : script to plot a spectrum from the catalog and compare it with the Fermi-LAT spectrum. In order to use this script, the `ReadFermiCatalogs.py` class is needed.

## FITS tables description

### Tables in the `HEGS_FOVs_v1.fits` file

FITS table containing information on the observed field-of-views :

| Column | Units | Description |
|---|---|---|
| FOV\_Name |  | Name |
| Center\_RA | deg | Right Ascension (J2000) of the center of the cluster |
| Center\_DEC | deg | Declination (J2000) of the center of the cluster |
| ExtX | deg | Half-extension of the cluster map along the Right Ascension axis |
| ExtY | deg | Half-extension of the cluster map along the Declination axis |

FITS table containing information on the observation time per field-of-view : 

| Column | Units | Description |
|---|---|---|
| FOV\_Name |  | Name |
| Time\_MJD | d | List of start dates (at noon before the night) |
| LiveTime | s | List of observation live time (in seconds) for each night containing observations |

### Tables in the `HEGS_catalogue_v1.fits` file

#### HEGS_Source table

 PL stands for Power Law and LP for LogParabola

| Column | Units | Description |
|---|---|---|
| Source\_Name |  | Source name (HESS JHHmm$\pm$DDd identifier) |
| RAJ2000 | deg | Right Ascension (J2000) |
| DECJ2000 | deg | Declination (J2000) |
| nON |  | Number of events in the ON region |
| nOFF |  |Number of events in the OFF regions |
| Alpha |  | Normalisation of the OFF regions |
| LiMa\_Significance |  | Significance of the signal |
| LiveTime | h  | Live time in hours |
| Flux\_Spec\_PL\_Diff\_Pivot | photons/cm<sup>2</sup>/s/TeV  | Differential flux at pivot energy |
| Flux\_Spec\_PL\_Diff\_Pivot\_Err | photons/cm<sup>2</sup>/s/TeV   | Statistical error (1 sigma) on Flux\_Spec\_PL\_Diff\_Pivot |
| Index\_Spec\_PL |  | Spectral index |
| Index\_Spec\_PL\_Err |  | Statistical error (1 sigma) on Index\_Spec\_PL |
| Pivot\_Energy | TeV | Pivot energy |
| Spectral\_Model |  | Preferred spectral model |
| Emin\_Spectrum |   TeV| Minimal energy of the spectrum |
| Emax\_Spectrum |  TeV | Maximal energy of the spectrum |
| Flux\_Spec\_LP\_Diff\_Pivot |  photons/cm<sup>2</sup>/s/TeV  | Differential flux at pivot energy |
| Flux\_Spec\_LP\_Diff\_Pivot\_Err |  photons/cm<sup>2</sup>/s/TeV  | Statistical error (1 sigma) on Flux\_Spec\_LP\_Diff\_Pivot |
| Alpha\_Spec\_LP |  | Spectral index |
| Alpha\_Spec\_LP\_Err |  |Statistical error (1 sigma) on Alpha\_Spec\_LP  |
| Beta\_Spec\_LP |  | Curvature value |
| Beta\_Spec\_LP\_Err |  | Statistical error (1 sigma) on Beta\_Spec\_LP_Err |
| Flux\_Spec\_PL\_Diff\_Pivot\_EBL | photons/cm<sup>2</sup>/s/TeV  | Differential flux at pivot energy |
| Flux\_Spec\_PL\_Diff\_Pivot\_Err\_EBL | photons/cm<sup>2</sup>/s/TeV  | Statistical error (1 sigma) on Flux\_Spec\_LP\_Diff\_Pivot_EBL |
| Index\_Spec\_PL\_EBL |  | Spectral index, EBL corrected |
| Index\_Spec\_PL\_Err\_EBL |  |Statistical error (1 sigma) on Index\_Spec\_PL\_EBL |
| Pivot\_Energy\_EBL | TeV | Pivot energy |
| Redshift |  | Redshift of the source |
| Energy | TeV  | Centre of the energy bin |
| Delta\_Energy\_Up |  TeV  | High energy bound of the energy bin |
| Delta\_Energy\_Low | TeV | Low energy bound of the energy bin |
| Differential\_Flux | photons/cm<sup>2</sup>/s/TeV  | Differential flux at Energy |
| Differential\_Flux\_Err | photons/cm<sup>2</sup>/s/TeV | Statistical error (1 sigma) on Differential_Flux, 0 if upper limit |
| Time\_MJD | d | Time in days of the Light curve point (only for sources identified as variable) |
| Flux\_above\_300GeV& cm$^{-2}$ s$^{-1}$ | Integral flux above 300 GeV |
| Flux\_above\_300GeV\_Err& cm$^{-2}$ s$^{-1}$ | Statistical error (1 sigma) on Integral flux above 300 GeV |

#### Association table

| Column | Description |
|---|---|
| Source\_Name | Source name (HESS JHHmm±DDd identifier) |
| Association| Name of the associated source |
| HEGS FoV | Name of the HEGS field-of-view |
| Redshift | value of the redshift |
| Type | Classification of the object | 

#### Constrained sources table

| Column        | Units       | description   |
|---|----|---|
| 4FGLName      |              | Source name (4FGL JHHmm±DDd identifier)              |
| RAJ2000       | deg         | Right Ascension (J2000)                             |
| DECJ2000      | deg         | Declination (J2000)                                   |
| Redshift     |              | value of the redshift                                 |
| LiMa\_Significance |          | Detection Significance                                  |
| Excess        |              | Number of excess events                               |
| LiveTime      | h           | Live time in hours                                      |
| UpperLimit_1TeV | photons/cm<sup>2</sup>/s/TeV | Upper limit on the differential flux at 1 TeV (95\% CL) |
| Energy\_threshold | TeV        | Average energy threshold                              |

### `Maps` FITS files


| Maps        | Units       | description       |
|---|---|---|
| LiveTime     | h           | Acceptance corrected live time in hours                 |
| SignificanceMap | -          | Significance of the signal                            |
| Average\_EThreshold | TeV        | Average energy threshold                              |
| FluxMap      | photons/cm<sup>2</sup>/s/TeV  | Differential flux at 1 TeV                                    |
| FluxErrorMap | photons/cm<sup>2</sup>/s/TeV  | Error on the differential flux at 1 TeV                     |
| FluxULMap    | photons/cm<sup>2</sup>/s/TeV  | Upper limit on the differential flux at 1 TeV (95\% CL) |
| FluxSensitivityMap_Sig5p0 | photons/cm<sup>2</sup>/s/TeV  | Flux sensitivity at $5.0$ sigma                            |
| FluxSensitivityMap_Sig5p7 | photons/cm<sup>2</sup>/s/TeV  | Flux sensitivity at $5.7$ sigma                            |

### Table in the `HEGS_NotConstrainedSources_v1.fits` file

| Column        | Units       | description   |
|---|----|---|
| 4FGLName      |              | Source name (4FGL JHHmm±DDd identifier)              |
| RAJ2000       | deg         | Right Ascension (J2000)                             |
| DECJ2000      | deg         | Declination (J2000)                                   |
| Redshift     |              | Value of the redshift                                 |
| LiMa\_Significance |          |  Significance of the signal                                  |
| Excess        |              | Number of excess events                               |
| LiveTime      | h           | Live time in hours                                      |
| UpperLimit_1TeV | photons/cm<sup>2</sup>/s/TeV | Upper limit on the differential flux at 1 TeV (95\% CL) |
| Energy\_threshold | TeV        | Average energy threshold                              |

