import pandas as pd
import matplotlib as mpl
import numpy as np
import matplotlib.pyplot as plt

mpl.rcParams['pdf.fonttype']=42
mpl.rcParams['xtick.color'] = 'black'
mpl.rcParams['xtick.direction'] = 'in'
mpl.rcParams['ytick.direction'] = 'in'

def cm2inch(value):
    return value/2.54

def powerlaw(p, x):
    t0 = np.power(10,4.334)
    m, c = p
    return m*(x/t0)**(-c)

x_time = np.linspace(5e3,1e6,200)

#hess data
HESS = pd.read_csv("hess_lc.csv")
alpha_vhe, alpha_vhe_err = 1.08556, 0.04686
y_time = powerlaw([3.40386930e-11, alpha_vhe],x_time)

#the XRT lightcurve
xrt_rebin = pd.read_csv("swift_rebin.csv")
xrt_rebin_h = pd.read_csv("swift_hess.csv")
alpha_xrt, alpha_xrt_err = 1.07169, 0.091353
x_time_xrt = np.linspace(5e3,1e6,200)
y_time_xrt = powerlaw([9.71608683e-11, alpha_xrt],x_time_xrt)

#the bat lightcurve
bat = pd.read_csv("bat.csv")

#LAT UL from the GCN
lat_time, lat_err_time = [8000.0, 20000.0],[2000.0, 10000.0]
lat_upplims = np.array([3.2e-10, 1.4e-10])

cmap = mpl.cm.get_cmap('tab10')
cc = np.linspace(0,1,6)
color_LAT = 'grey'
color_GBM = cmap(cc[1])
color_Optical = cmap(cc[2])
color_SwiftBAT = 'darkmagenta' #cmap(cc[3]) #
color_SwiftXRT = 'navy'
color_HESS = (219./255., 41./255., 25./255.) #Red HESS #cmap(cc[5])

swiftkwargs   = { 'fmt': 's', 'color': color_SwiftXRT , 'markerfacecolor': color_SwiftXRT, 'linestyle':'','markersize':2, 'alpha':0.7, 'linewidth':1.5 }
batkwargs   = { 'fmt': '.', 'color': color_SwiftBAT , 'linestyle':'', 'markersize':4,'alpha':0.7, 'linewidth':1.0 }

ha = 'right'
fw = 'normal'
tx = 2e6
labelsize = 7

fig = plt.figure(figsize=(cm2inch(12.0),4.0))
ax1 = fig.add_axes((.15,.4,1.0,.5))

ax1.set_xscale('log')
ax1.set_yscale('log')
ax1.grid()

ax2 = fig.add_axes((.15,.15,1.0,.25))


ax2.set_ylabel("Photon\nindex", labelpad = 10, fontsize = 7)
ax1.set_ylabel(r'Energy flux (erg cm$^{-2}$ s$^{-1}$)', fontsize = 7)

ax2.set_xlabel(r"Time since T$_0$ trigger (s)", fontsize = 7)
ax2.set_xscale('log')

ax2.grid()


ax1.errorbar(xrt_rebin["Time"], xrt_rebin["flux"], xerr = xrt_rebin["Time_err"], yerr = [xrt_rebin["flux_error_lo"],xrt_rebin["flux_error_hi"]],zorder = 10, **swiftkwargs)
swiftkwargs_   = { 'fmt': 's', 'color': color_SwiftXRT ,'markerfacecolor': 'none', 'linestyle':'','markersize':5, 'alpha':0.7, 'linewidth':1.0 }
ax1.errorbar(xrt_rebin_h["Time"], xrt_rebin_h["flux"], xerr = xrt_rebin_h["Time_err"], yerr = [xrt_rebin_h["flux_error_lo"],xrt_rebin_h["flux_error_hi"]], zorder = 19, **swiftkwargs_)
ax1.errorbar(HESS["Time"], HESS["EFlux"], xerr = HESS["Time_err"], yerr = HESS["EFlux_err"], color = color_HESS, fmt = '.', markersize = 8, zorder = 20)
ax1.errorbar(lat_time, lat_upplims, xerr = lat_err_time, yerr = 0.3*lat_upplims , color = color_LAT, uplims = True, fmt = '', zorder = 10, markersize = 3, linewidth = 1.0, linestyle = 'none')

ax1.plot(x_time,y_time, linestyle = '--', color = color_HESS, linewidth = 0.5)
ax1.plot(x_time_xrt,y_time_xrt, linestyle = '--', color = color_SwiftXRT, linewidth = 0.5)

tx = 2.5e2
yT = np.logspace(np.log10(2.0e-11),np.log10(3.5e-12),4)
ha = 'left'
ax1.text(tx,yT[2], r"$\alpha_{\rm HESS}=%0.2f +/- %0.2f$"%(alpha_vhe, alpha_vhe_err), color = color_HESS, fontsize = 7, horizontalalignment = ha)
ax1.text(tx,yT[3], r"$\alpha_{\rm XRT}=%0.2f +/- %0.2f$"%(alpha_xrt, alpha_xrt_err), color = color_SwiftXRT, fontsize = 7, horizontalalignment = ha)



yT = np.logspace(np.log10(1.3e-8),np.log10(2.5e-9),4)
tx = 2.5e2
ha = "left"
ax1.text(tx,yT[0], "H.E.S.S. (200 GeV - 4.0 TeV)",fontsize = 7,color = color_HESS, fontweight = fw, horizontalalignment = ha)
ax1.text(tx,yT[3], "Swift-XRT (0.3 keV - 10 keV)",fontsize = 7,color = color_SwiftXRT, fontweight = fw, horizontalalignment = ha,zorder = 20)
ax1.text(tx,yT[2], "Swift-BAT (15 keV - 50 keV)",fontsize = 7,color = color_SwiftBAT, fontweight = fw, horizontalalignment = ha,zorder = 20)
ax1.text(tx,yT[1], "Fermi-LAT (100 MeV - 1 GeV)", fontsize = 7,color = color_LAT, fontweight = fw,horizontalalignment = ha,zorder = 19)

ax1.tick_params('both',which = 'both',labelsize = labelsize, direction = 'in',bottom = True, top =True, right = True, left = True,grid_linestyle = '--', grid_alpha = 0.5)
ax2.tick_params('both',which = 'both',labelsize = labelsize, direction = 'in',bottom = True, top =True, right = True, left = True,grid_linestyle = '--', grid_alpha = 0.5)
ax1.grid()
ax1.grid(which='major',linewidth = 1.0, alpha=0.2)

ax2.grid()
ax2.grid(which='major',linewidth = 1.0, alpha=0.2)

locmaj = mpl.ticker.LogLocator(base=10,  numticks=11)
ax1.yaxis.set_major_locator(locmaj)
locmin = mpl.ticker.LogLocator(base=10.0, subs=(0.1,0.2,0.3,0.4,0.5,0.6,0.7,0.8,0.9),
                               numticks=100)
ax1.yaxis.set_minor_locator(locmin)
ax1.yaxis.set_minor_formatter(mpl.ticker.NullFormatter())

ax1.annotate("A", fontsize = 9, fontweight = 'bold', xy = (2.9e2,1.4e-12), ha = 'right')
ax2.annotate("B", fontsize = 9, fontweight = 'bold', xy = (2.9e2,1.7), ha = 'right')

ax2.errorbar(HESS["Time"], HESS["Index"],  color = color_HESS, fmt = "-", markersize = 2, zorder = 100, linewidth = 1.5)
ax2.errorbar(xrt_rebin["Time"], xrt_rebin["gamma"], xerr = xrt_rebin["Time_err"], yerr = [xrt_rebin["gamma_error_lo"],xrt_rebin["gamma_error_hi"]], **swiftkwargs)
ax2.errorbar(xrt_rebin_h["Time"], xrt_rebin_h["gamma"], xerr = xrt_rebin_h["Time_err"], yerr = [xrt_rebin_h["gamma_error_lo"],xrt_rebin_h["gamma_error_hi"]], zorder = 12, **swiftkwargs_)



#Expand whole mwl
ax1.set_xlim(1.9e2,3e6)
ax2.set_xlim(1.9e2,3e6)
ax2.set_ylim(1.4,2.8)
ax1.set_ylim(1e-12,5e-8)

ax1.annotate("GRB 190829A", xy = (2.5e2,2.2e-8),fontsize = 7, fontweight = 'bold', color = color_HESS, ha= 'left')

ax3 = fig.add_axes((.87,.67,.25,.2))
ax3.errorbar(bat["Time"], bat["Flux"], xerr = bat["Time_u"], yerr = bat["Flux_u"], **batkwargs)
ax3.set_yscale('log')
ax3.tick_params('both',which = 'both',labelsize = labelsize, direction = 'in',bottom = True, top =True, right = True, left = True,grid_linestyle = '--', grid_alpha = 0.5)
ax3.set_ylabel('Energy flux\n'+r'(erg cm$^{-2}$ s$^{-1}$)', fontsize = 7, labelpad = -1)
ax3.set_xlabel(r"Time since T$_0$ trigger (s)", fontsize = 7, labelpad = -1 )#ax3.plot(1,1)
ax3.annotate("C", fontsize = 9, fontweight = 'bold', xy = (98,4e-7), ha = 'right')
ax3.set_xlim(40,102)
ax3.grid()

#plt.show()
plt.savefig("lightcurve.pdf",bbox_inches = "tight")
